	function [Zodd, Podd, Zeven, Peven] = SORT_LATTICE_POLES_LP_Z(P)
	
	% 	Sorts the poles and zeros of a digital lowpass filter into poles 
	%	and zeros for upper and lower branches in a lattice filter according
	%	to section 12.2.1. 
	
	%	Toolbox for DIGITAL FILTERS USING MATLAB 	
	
	% 	Author: 		Lars Wanhammar 2009-08-09
	% 	Modified by: 	LW  Beginning of WWI + 100
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:		1 
	% 	Known bugs:		
	% 	Report bugs to:	Wanhammar@gmail.com
	
	Ps = (P-1)./(P+1);	
	[Zodd_a, Podd_a, Zeven_a, Peven_a] = SORT_LATTICE_POLES_LP_S(Ps);
	Podd = (1 + Podd_a)./(1 - Podd_a);				% Bilinear transformation
	Peven = (1 + Peven_a)./(1 - Peven_a);	
	Zodd = 1./Podd;
	Zeven = 1./Peven;
	if 1==1
		if mod((length(Podd)-1)/2,2) == 0,  Godd = 1; else Godd = -1;  end	
		if mod(length(Peven)/2,2) == 1, Geven = -1; else Geven = 1; end
		Zodd = Godd./Podd;
		Zeven = Geven./Peven;	
		
	end	
